﻿Public Class Exportt3d
    Public Shared AllTheText As String = ""

    Public Structure ATile
        Public ActualName As String
        Public Actualt3d As String
        Public ID As Integer
    End Structure

    Public Structure AnActor
        Public ActualName As String
        Public Actualt3d As String
    End Structure

    Public Shared Sub Exportt3d(ByVal Filepath As String, ByVal CreatePathNotes As Boolean, ByVal CreateLighting As Boolean)
        AllTheText = ""
        Dim DebugCT As String = "Unknown ( not logged )" ' Used for debug crash message
        'First the entry and levelinfo.
        AllTheText += "Begin Map" + vbNewLine
        AllTheText += "Begin Actor Class=LevelInfo" + vbNewLine
        AllTheText += "    LevelEnterText=" + Chr(34) + "Created using Unreal dungeon maker, by Henry00 ( de Jongh )" + Chr(34) + vbNewLine
        AllTheText += "    Region=(Zone=LevelInfo'MyLevel.LevelInfo0',iLeaf=-1)" + vbNewLine
        Try
            If Main.MyMap_Song <> "" Then
                AllTheText += "    Song=Music'" + Strings.Split(Main.MyMap_Song, ".").GetValue(0).ToString + "." + Strings.Split(Main.MyMap_Song, ".").GetValue(0).ToString + "'" + vbNewLine
            End If
        Catch Ex As Exception
            MsgBox("Invalid song filename!", MsgBoxStyle.Exclamation)
        End Try
        AllTheText += "End Actor" + vbNewLine
        'now add all the brushes
        Dim counter As Integer = 0
        WaitBar.Owner = Main
        WaitBar.Show()
        WaitBar.Enabled = False
        Try
            Main.Enabled = False
            Main.Refresh()
            Application.DoEvents()
            Try
                If My.Computer.FileSystem.FileExists(Filepath) Then
                    My.Computer.FileSystem.DeleteFile(Filepath)
                End If
            Catch Ex As Exception
                MsgBox("I doubt this will go right, but lets give it a try.. :S" + vbNewLine + Ex.Message, MsgBoxStyle.Critical)
            End Try
            System.IO.File.WriteAllText(Filepath, AllTheText, System.Text.Encoding.Default)
            AllTheText = "" ' Anti double begin
            If Not EditorResources.CompileStarted Then
                'Create the red brush
                AddACube(0, 200, 200)
                counter = 1
                EditorResources.CompileStarted = True
            End If
            Dim ForScrollBarValueMax As Integer = Main.AllPoints.Count
            Dim UsedActors As New List(Of AnActor)

            ' T3D BRUSH MODEL HEADER
            '   To do this, we need to create a list of all used tiles
            Dim UsedTiles As New List(Of String)
            For Each I As Main.UDM_GRID.UDM_CELL In Main.AllPoints
                Dim FoundTile As Boolean = False
                For Each II As String In UsedTiles
                    If I.Tile = II Then
                        FoundTile = True
                        Exit For
                    End If
                Next
                If Not FoundTile Then
                    UsedTiles.Add(I.Tile)
                End If
                FoundTile = False
            Next
            ' T3D BRUSHES PLACEMENT
            '   Loop Through all UsedTiles and give them IDs
            Dim TEMP_IDCounter As Integer = 1 ' 0 = red brush
            Dim UsedTilesF As New List(Of ATile) ' Stores all final
            For Each I As String In UsedTiles
                Dim lol As New ATile ' Create new Tile
                ' Get content from file
                Try
                    lol.Actualt3d = System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\Toolbox\" + I + "\data.txt", System.Text.Encoding.Default)
                    lol.ActualName = I
                    lol.ID = TEMP_IDCounter
                    UsedTilesF.Add(lol)
                Catch Ex As Exception
                    MsgBox("Could not read t3d code of tile: " + I + vbNewLine + "Error: " + Ex.Message, MsgBoxStyle.Critical)
                    Exit Sub
                End Try
                TEMP_IDCounter += 1
            Next
            '   Now loop through all placed actors, and rock&roll
            Dim AllImportedTiles As New List(Of String)
            Dim AllImportedTilesAlreadyDone As Boolean = False
            Dim FoundActor As Boolean = False
            For Each I As Main.UDM_GRID.UDM_CELL In Main.AllPoints
                WaitBar.ProgressBar.Value = Math.Round((counter / ForScrollBarValueMax) * 100)
                WaitBar.Refresh()
                Application.DoEvents()
                ' START OF ANOTHER TILE
                AllImportedTilesAlreadyDone = False
                Dim New_Tile_X As Integer = 0
                Dim New_Tile_Y As Integer = 0
                Dim New_Tile_Name As String = ""
                Dim New_Tile_ActorOnTop As Boolean = False
                Dim New_Tile_Layer As String = ""
                Dim New_Tile_Actor As Main.UDM_AGRID.UDM_CELL = Nothing
                Dim New_Tile_TheT3D As String = ""
                Dim New_Tile_ID As Integer = 0

                For Each X As ATile In UsedTilesF
                    If X.ActualName = I.Tile Then
                        New_Tile_X = I.X
                        New_Tile_Y = I.Y
                        New_Tile_Name = X.ActualName
                        New_Tile_Layer = I.Actor
                        New_Tile_ActorOnTop = Main._MAP_HALLWAYSA.SContains(New_Tile_X, New_Tile_Y, "", True, New_Tile_Layer)
                        If New_Tile_ActorOnTop Then
                            New_Tile_Actor = Main._MAP_HALLWAYSA.SContainsTileCELLResult
                        End If
                        New_Tile_TheT3D = X.Actualt3d
                        New_Tile_ID = X.ID
                        ' Parse values

                        ' Check if modellist already exists
                        For Each XXX As String In AllImportedTiles
                            If XXX = New_Tile_Name Then
                                AllImportedTilesAlreadyDone = True
                            End If
                        Next
                        If Not AllImportedTilesAlreadyDone Then
                            ' Add modellist
                            Dim TheText As String = ""
                            Dim StartStop As Boolean = False

                            DebugCT = New_Tile_Name + " @Polylist may not have a start and end posistion!"
                            TheText = New_Tile_TheT3D.Substring(New_Tile_TheT3D.IndexOf("[POLYLIST_START]"), New_Tile_TheT3D.IndexOf("[POLYLIST_END]"))
                            'Since startindex cannot be less then 0 for some reason, remove it manually
                            TheText = Strings.Replace(TheText, "[POLYLIST_START]", "")

                            New_Tile_TheT3D = Strings.Split(New_Tile_TheT3D, "[POLYLIST_END]").GetValue(1).ToString
                            ' Now we have the t3d inside "TheText" and the actor stuff inside "New_Tile_TheT3D"
                            New_Tile_TheT3D = Strings.Replace(New_Tile_TheT3D, "[POLYLIST]", vbNewLine + TheText)
                            AllImportedTiles.Add(New_Tile_Name)
                        Else
                            ' Only add Brush
                            New_Tile_TheT3D = Strings.Split(New_Tile_TheT3D, "[POLYLIST_END]").GetValue(1).ToString
                            New_Tile_TheT3D = Strings.Replace(New_Tile_TheT3D, "[POLYLIST]", "")
                        End If

                        While Strings.InStr(New_Tile_TheT3D, "{{[XPOS]}}")
                            New_Tile_TheT3D = Strings.Replace(New_Tile_TheT3D, "{{[XPOS]}}", ((New_Tile_X / 32) * 256).ToString)
                        End While
                        While Strings.InStr(New_Tile_TheT3D, "{{[YPOS]}}")
                            New_Tile_TheT3D = Strings.Replace(New_Tile_TheT3D, "{{[YPOS]}}", ((New_Tile_Y / 32) * 256).ToString)
                        End While
                        While Strings.InStr(New_Tile_TheT3D, "{{[ZPOS]}}")
                            New_Tile_TheT3D = Strings.Replace(New_Tile_TheT3D, "{{[ZPOS]}}", CalcZbasedOnLayer(New_Tile_Layer).ToString)
                        End While
                        While Strings.InStr(New_Tile_TheT3D, "{{[MODELNR]}}")
                            New_Tile_TheT3D = Strings.Replace(New_Tile_TheT3D, "{{[MODELNR]}}", New_Tile_ID.ToString)
                        End While
                        New_Tile_TheT3D = FixZ(New_Tile_TheT3D, New_Tile_Layer)

                        Exit For
                    End If
                Next
                AllTheText += New_Tile_TheT3D
                ' END OF ANOTHER TILE

                ' START OF ACTOR MASSACRE

                ' Add templates
                AddPathNode((New_Tile_X / 32) * 256, (New_Tile_Y / 32) * 256, CreatePathNotes, New_Tile_Layer)
                AddLighting((New_Tile_X / 32) * 256, (New_Tile_Y / 32) * 256, CreateLighting, New_Tile_Layer)
                ' Add custom actors
                Try
                    If New_Tile_ActorOnTop Then
                        FoundActor = False
                        Dim FA As String = ""
                        For Each X As AnActor In UsedActors
                            If New_Tile_Actor.Tile = X.ActualName Then
                                FoundActor = True
                                'Set T3D
                                FA = X.Actualt3d
                                Exit For
                            End If
                        Next
                        If Not FoundActor And New_Tile_Actor.Tile <> "" Then
                            Dim X As New AnActor
                            X.ActualName = New_Tile_Actor.Tile
                            If My.Computer.FileSystem.FileExists(My.Application.Info.DirectoryPath + "\Actors\" + New_Tile_Actor.Tile + "\data.txt") Then
                                X.Actualt3d = System.IO.File.ReadAllText(My.Application.Info.DirectoryPath + "\Actors\" + New_Tile_Actor.Tile + "\data.txt", System.Text.Encoding.Default)
                            Else
                                MsgBox("Could not find file needed for exporting!" + vbNewLine + My.Application.Info.DirectoryPath + "\Actors\" + New_Tile_Actor.Tile + "\data.txt", MsgBoxStyle.Critical)
                                Exit For
                            End If
                            UsedActors.Add(X)
                            'Set T3D
                            FA = X.Actualt3d
                        End If
                        AllTheText += vbNewLine + FA
                        ' Last parse on actors, but might fix something else if happen to be there ( not really )
                        While Strings.InStr(AllTheText, "{{[XPOS]}}")
                            AllTheText = Strings.Replace(AllTheText, "{{[XPOS]}}", ((New_Tile_X / 32) * 256).ToString)
                        End While
                        While Strings.InStr(AllTheText, "{{[YPOS]}}")
                            AllTheText = Strings.Replace(AllTheText, "{{[YPOS]}}", ((New_Tile_Y / 32) * 256).ToString)
                        End While
                        While Strings.InStr(AllTheText, "{{[ZPOS]}}")
                            AllTheText = Strings.Replace(AllTheText, "{{[ZPOS]}}", CalcZbasedOnLayer(New_Tile_Layer).ToString)
                        End While
                        AllTheText = FixZ(AllTheText, New_Tile_Layer)
                    End If
                Catch Ex As Exception
                    MsgBox("Could not read t3d code of actor: " + New_Tile_Name + vbNewLine + "Error: " + Ex.Message, MsgBoxStyle.Critical)
                    Exit For
                End Try
                ' END OF ACTOR MASSACRE


                counter += 1
                System.IO.File.AppendAllText(Filepath, AllTheText)
                'Dump to file and clean it again to keep the speed alive!
                AllTheText = ""
            Next

            AllTheText += vbNewLine + "End Map"
            System.IO.File.AppendAllText(Filepath, AllTheText)
            WaitBar.Close()
            Main.Enabled = True
            EditorResources.CompileStarted = False
        Catch ex As Exception
            WaitBar.Close()
            Main.Enabled = True
            EditorResources.CompileStarted = False
            MsgBox("Compilation failed!" + vbNewLine + ex.Message + vbNewLine + vbNewLine + "@Tile:" + DebugCT, MsgBoxStyle.Critical, "Fatal error")
        End Try
    End Sub

#Region "Cube_Vertex"
    Public Shared Sub AddACube(ByVal CubeNumber As Integer, ByVal X As Integer, ByVal Y As Integer)
        AllTheText += "Begin Actor Class=Brush" + vbNewLine
        AllTheText += "    CsgOper=CSG_Subtract" + vbNewLine
        AllTheText += "    MainScale=(SheerAxis=SHEER_ZX)" + vbNewLine
        AllTheText += "    PostScale=(SheerAxis=SHEER_ZX)" + vbNewLine
        AllTheText += "    bDynamicLight=True" + vbNewLine
        AllTheText += "    Level=LevelInfo'MyLevel.LevelInfo0'" + vbNewLine
        AllTheText += "    XLevel=Level'MyLevel.MyLevel'" + vbNewLine
        AllTheText += "    Tag=Brush" + vbNewLine
        AllTheText += "    Region=(Zone=LevelInfo'MyLevel.LevelInfo0',iLeaf=-1)" + vbNewLine
        AllTheText += "    Location=(X=-" + X.ToString + ".000000,Y=-" + Y.ToString + ".000000)" + vbNewLine
        AllTheText += "    Begin Brush Name=Model0" + vbNewLine
        AllTheText += "       Begin PolyList" + vbNewLine
        AllTheText += "          Begin Polygon Texture=TempBG" + vbNewLine
        AllTheText += "             Origin   -00128.000000,-00128.000000,-00128.000000" + vbNewLine
        AllTheText += "             Normal   -00001.000000,+00000.000000,+00000.000000" + vbNewLine
        AllTheText += "             TextureU +00000.000000,+00001.000000,+00000.000000" + vbNewLine
        AllTheText += "             TextureV +00000.000000,+00000.000000,-00001.000000" + vbNewLine
        AllTheText += "             Vertex   -00128.000000,-00128.000000,-00128.000000" + vbNewLine
        AllTheText += "             Vertex   -00128.000000,-00128.000000,+00128.000000" + vbNewLine
        AllTheText += "             Vertex   -00128.000000,+00128.000000,+00128.000000" + vbNewLine
        AllTheText += "             Vertex   -00128.000000,+00128.000000,-00128.000000" + vbNewLine
        AllTheText += "          End Polygon" + vbNewLine
        AllTheText += "          Begin Polygon Texture=TempBG" + vbNewLine
        AllTheText += "             Origin   -00128.000000,+00128.000000,-00128.000000" + vbNewLine
        AllTheText += "             Normal   +00000.000000,+00001.000000,+00000.000000" + vbNewLine
        AllTheText += "             TextureU +00001.000000,-00000.000000,+00000.000000" + vbNewLine
        AllTheText += "             TextureV +00000.000000,+00000.000000,-00001.000000" + vbNewLine
        AllTheText += "             Vertex   -00128.000000,+00128.000000,-00128.000000" + vbNewLine
        AllTheText += "             Vertex   -00128.000000,+00128.000000,+00128.000000" + vbNewLine
        AllTheText += "             Vertex   +00128.000000,+00128.000000,+00128.000000" + vbNewLine
        AllTheText += "             Vertex   +00128.000000,+00128.000000,-00128.000000" + vbNewLine
        AllTheText += "          End Polygon" + vbNewLine
        AllTheText += "          Begin Polygon Texture=TempBG" + vbNewLine
        AllTheText += "             Origin   +00128.000000,+00128.000000,-00128.000000" + vbNewLine
        AllTheText += "             Normal   +00001.000000,+00000.000000,+00000.000000" + vbNewLine
        AllTheText += "             TextureU +00000.000000,-00001.000000,+00000.000000" + vbNewLine
        AllTheText += "             TextureV +00000.000000,+00000.000000,-00001.000000" + vbNewLine
        AllTheText += "             Vertex   +00128.000000,+00128.000000,-00128.000000" + vbNewLine
        AllTheText += "             Vertex   +00128.000000,+00128.000000,+00128.000000" + vbNewLine
        AllTheText += "             Vertex   +00128.000000,-00128.000000,+00128.000000" + vbNewLine
        AllTheText += "             Vertex   +00128.000000,-00128.000000,-00128.000000" + vbNewLine
        AllTheText += "          End Polygon" + vbNewLine
        AllTheText += "          Begin Polygon Texture=TempBG" + vbNewLine
        AllTheText += "             Origin   +00128.000000,-00128.000000,-00128.000000" + vbNewLine
        AllTheText += "             Normal   +00000.000000,-00001.000000,+00000.000000" + vbNewLine
        AllTheText += "             TextureU -00001.000000,-00000.000000,-00000.000000" + vbNewLine
        AllTheText += "             TextureV +00000.000000,+00000.000000,-00001.000000" + vbNewLine
        AllTheText += "             Vertex   +00128.000000,-00128.000000,-00128.000000" + vbNewLine
        AllTheText += "             Vertex   +00128.000000,-00128.000000,+00128.000000" + vbNewLine
        AllTheText += "             Vertex   -00128.000000,-00128.000000,+00128.000000" + vbNewLine
        AllTheText += "             Vertex   -00128.000000,-00128.000000,-00128.000000" + vbNewLine
        AllTheText += "          End Polygon" + vbNewLine
        AllTheText += "          Begin Polygon Texture=TempBG" + vbNewLine
        AllTheText += "             Origin   -00128.000000,+00128.000000,+00128.000000" + vbNewLine
        AllTheText += "             Normal   +00000.000000,+00000.000000,+00001.000000" + vbNewLine
        AllTheText += "             TextureU +00001.000000,+00000.000000,+00000.000000" + vbNewLine
        AllTheText += "             TextureV +00000.000000,+00001.000000,+00000.000000" + vbNewLine
        AllTheText += "             Vertex   -00128.000000,+00128.000000,+00128.000000" + vbNewLine
        AllTheText += "             Vertex   -00128.000000,-00128.000000,+00128.000000" + vbNewLine
        AllTheText += "             Vertex   +00128.000000,-00128.000000,+00128.000000" + vbNewLine
        AllTheText += "             Vertex   +00128.000000,+00128.000000,+00128.000000" + vbNewLine
        AllTheText += "          End Polygon" + vbNewLine
        AllTheText += "          Begin Polygon Texture=TempBG" + vbNewLine
        AllTheText += "             Origin   -00128.000000,-00128.000000,-00128.000000" + vbNewLine
        AllTheText += "             Normal   +00000.000000,+00000.000000,-00001.000000" + vbNewLine
        AllTheText += "             TextureU +00001.000000,+00000.000000,+00000.000000" + vbNewLine
        AllTheText += "             TextureV +00000.000000,-00001.000000,+00000.000000" + vbNewLine
        AllTheText += "             Vertex   -00128.000000,-00128.000000,-00128.000000" + vbNewLine
        AllTheText += "             Vertex   -00128.000000,+00128.000000,-00128.000000" + vbNewLine
        AllTheText += "             Vertex   +00128.000000,+00128.000000,-00128.000000" + vbNewLine
        AllTheText += "             Vertex   +00128.000000,-00128.000000,-00128.000000" + vbNewLine
        AllTheText += "          End Polygon" + vbNewLine
        AllTheText += "       End PolyList" + vbNewLine
        AllTheText += "    End Brush" + vbNewLine
        AllTheText += "    Brush=Model'MyLevel.Model0" + "'" + vbNewLine
        AllTheText += "    Name=Brush" + CubeNumber.ToString + vbNewLine
        AllTheText += "End Actor"
    End Sub
#End Region ' Also used for red brush, keep keep
#Region "Special Actors"
    Public Shared Sub AddPathNode(ByVal X As Integer, ByVal Y As Integer, ByVal Add As Boolean, ByVal TheLayer As String)
        If Add Then
            AllTheText += vbNewLine + "Begin Actor Class=PathNode" + vbNewLine
            AllTheText += "    Region=(Zone=LevelInfo'MyLevel.LevelInfo0',iLeaf=-1)" + vbNewLine
            AllTheText += "    Location=(X=-" + X.ToString + ".000000,Y=-" + Y.ToString + ".000000,Z=" + FixZ("{{[CalcZ][-90][/CalcZ]}}", TheLayer) + ")" + vbNewLine
            AllTheText += "End Actor"
        End If
    End Sub
    Public Shared Sub AddLighting(ByVal X As Integer, ByVal Y As Integer, ByVal Add As Boolean, ByVal TheLayer As String)
        If Add Then
            AllTheText += vbNewLine + "Begin Actor Class=Light" + vbNewLine
            AllTheText += "    Region=(Zone=LevelInfo'MyLevel.LevelInfo0',iLeaf=-1)" + vbNewLine
            AllTheText += "    Location=(X=-" + X.ToString + ".000000,Y=-" + Y.ToString + ".000000,Z=" + FixZ("{{[CalcZ][64][/CalcZ]}}", TheLayer) + ")" + vbNewLine
            AllTheText += "    LightBrightness=20" + vbNewLine
            AllTheText += "End Actor"
        End If
    End Sub
#End Region
#Region "Calculations"
    Public Shared Function CalcZbasedOnLayer(ByVal Layer As String) As Integer
        Dim Value As Integer = 0

        If Layer = "0" Then
            Value = 0
        ElseIf Layer = "-20" Then
            Value = -256 * 20
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 20
            End If
        ElseIf Layer = "-19" Then
            Value = -256 * 19
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 19
            End If
        ElseIf Layer = "-18" Then
            Value = -256 * 18
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 18
            End If
        ElseIf Layer = "-17" Then
            Value = -256 * 17
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 17
            End If
        ElseIf Layer = "-16" Then
            Value = -256 * 16
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 16
            End If
        ElseIf Layer = "-15" Then
            Value = -256 * 15
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 15
            End If
        ElseIf Layer = "-14" Then
            Value = -256 * 14
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 14
            End If
        ElseIf Layer = "-13" Then
            Value = -256 * 13
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 13
            End If
        ElseIf Layer = "-12" Then
            Value = -256 * 12
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 12
            End If
        ElseIf Layer = "-11" Then
            Value = -256 * 11
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 11
            End If
        ElseIf Layer = "-10" Then
            Value = -256 * 10
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 10
            End If
        ElseIf Layer = "-9" Then
            Value = -256 * 9
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 9
            End If
        ElseIf Layer = "-8" Then
            Value = -256 * 8
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 8
            End If
        ElseIf Layer = "-7" Then
            Value = -256 * 7
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 7
            End If
        ElseIf Layer = "-6" Then
            Value = -256 * 6
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 6
            End If
        ElseIf Layer = "-5" Then
            Value = -256 * 5
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 5
            End If
        ElseIf Layer = "-4" Then
            Value = -256 * 4
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 4
            End If
        ElseIf Layer = "-3" Then
            Value = -256 * 3
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 3
            End If
        ElseIf Layer = "-2" Then
            Value = -256 * 2
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 2
            End If
        ElseIf Layer = "-1" Then
            Value = -256
            If Main.MyMap_LayerSetting = 0 Then
                Value -= 16 * 1
            End If
        ElseIf Layer = "+20" Then
            Value = 256 * 20
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 20
            End If
        ElseIf Layer = "+19" Then
            Value = 256 * 19
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 19
            End If
        ElseIf Layer = "+18" Then
            Value = 256 * 18
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 18
            End If
        ElseIf Layer = "+17" Then
            Value = 256 * 17
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 17
            End If
        ElseIf Layer = "+16" Then
            Value = 256 * 16
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 16
            End If
        ElseIf Layer = "+15" Then
            Value = 256 * 15
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 15
            End If
        ElseIf Layer = "+14" Then
            Value = 256 * 14
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 14
            End If
        ElseIf Layer = "+13" Then
            Value = 256 * 13
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 13
            End If
        ElseIf Layer = "+12" Then
            Value = 256 * 12
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 12
            End If
        ElseIf Layer = "+11" Then
            Value = 256 * 11
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 11
            End If
        ElseIf Layer = "+10" Then
            Value = 256 * 10
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 10
            End If
        ElseIf Layer = "+9" Then
            Value = 256 * 9
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 9
            End If
        ElseIf Layer = "+8" Then
            Value = 256 * 8
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 8
            End If
        ElseIf Layer = "+7" Then
            Value = 256 * 7
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 7
            End If
        ElseIf Layer = "+6" Then
            Value = 256 * 6
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 6
            End If
        ElseIf Layer = "+5" Then
            Value = 256 * 5
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 5
            End If
        ElseIf Layer = "+4" Then
            Value = 256 * 4
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 4
            End If
        ElseIf Layer = "+3" Then
            Value = 256 * 3
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 3
            End If
        ElseIf Layer = "+2" Then
            Value = 256 * 2
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 2
            End If
        ElseIf Layer = "+1" Then
            Value = 256
            If Main.MyMap_LayerSetting = 0 Then
                Value += 16 * 1
            End If
        End If

        Return Value
    End Function

    ' Special calculations
    Public Shared Function FixZ(ByVal TheTextX As String, ByVal TheLayer As String)
        Dim Temp_Int1 As Integer = 0
        Dim Temp_Int2 As Integer = 0
        Dim Result As String = ""
        Dim SolutionValue As Integer = 0
        Dim TheText As String = TheTextX
        Try
            While Strings.InStr(TheText, "{{[CalcZ][")
                Temp_Int1 = TheText.IndexOf("{{[CalcZ][") + 10 ' Text length
                Temp_Int2 = TheText.IndexOf("][/CalcZ]}}")
                Result = TheText.Substring(Temp_Int1, Temp_Int2 - Temp_Int1)
                If Strings.InStr(Result, "+") Then
                    Result = Strings.Replace(Result, "+", "")
                    SolutionValue = CalcZbasedOnLayer(TheLayer) + CType(Result, Integer)
                    TheText = Strings.Replace(TheText, "{{[CalcZ][+" + Result + "][/CalcZ]}}", SolutionValue.ToString)
                ElseIf Strings.InStr(Result, "-") Then
                    Result = Strings.Replace(Result, "-", "")
                    SolutionValue = CalcZbasedOnLayer(TheLayer) - CType(Result, Integer)
                    TheText = Strings.Replace(TheText, "{{[CalcZ][-" + Result + "][/CalcZ]}}", SolutionValue.ToString)
                Else 'Expect pure value, so +
                    SolutionValue = CalcZbasedOnLayer(TheLayer) + CType(Result, Integer)
                    TheText = Strings.Replace(TheText, "{{[CalcZ][" + Result + "][/CalcZ]}}", SolutionValue.ToString)
                End If
                'Reset all values
                Temp_Int1 = 0
                Temp_Int2 = 0
                Result = ""
                SolutionValue = 0
            End While
        Catch Ex As Exception
            MsgBox("There was a problem while exporting!" + vbNewLine + "There is something wrong with: {{[CalcZ][??][/CalcZ]}}")
        End Try
        Return TheText
    End Function
#End Region
End Class
